## [Nmap Live Host Discovery](https://tryhackme.com/r/room/nmap01)

## Task-1: Introduction -- only reading

## Task-2: Subnetworks

**From computer1
To computer1 (to indicate it is broadcast)
Packet Type: “ARP Request”
Data: computer6 (because we are asking for computer6 MAC address using ARP Request)**

### How many devices can see the ARP Request?
Answer: 4 

### Did computer6 receive the ARP Request? (Y/N)
Answer: N

**From computer4
To computer4 (to indicate it is broadcast)
Packet Type: “ARP Request”
Data: computer6 (because we are asking for computer6 MAC address using ARP Request)**

### How many devices can see the ARP Request?
Answer: 4

### Did computer6 reply to the ARP Request? (Y/N)
Answer: Y

## Task-3: Enumerating Targets 

### What is the first IP address Nmap would scan if you provided 10.10.12.13/29 as your target?
Answer: 10.10.12.8

### How many IP addresses will Nmap scan if you provide the following range 10.10.0-255.101-125? 
Answer: 6400

## Task-4: Discovering Live Hosts

**Send a packet with the following:
From computer1
To computer3
Packet Type: “Ping Request**

### What is the type of packet that computer1 sent before the ping?
Answer: ARP Request

### What is the type of packet that computer1 received before being able to send the ping?
Answer: ARP Response

### How many computers responded to the ping request?
Answer: 1

**Send a packet with the following:
From computer2
To computer5
Packet Type: “Ping Request”**

### What is the name of the first device that responded to the first ARP Request?
Answer: router

### What is the name of the first device that responded to the second ARP Request?
Answer: computer5

### Send another Ping Request. Did it require new ARP Requests? (Y/N)
Answer: N

## Task-5: Nmap Host Discovery Using ARP

**From computer1
To computer1 (to indicate it is broadcast)
Packet Type: “ARP Request”
Data: try all the possible eight devices (other than computer1) in the network: computer2, computer3, computer4, computer5, computer6, switch1, switch2, and router.**

### How many devices are you able to discover using ARP requests?
Answer: 3

## Task-6: Nmap Host Discovery Using ICMP

### What is the option required to tell Nmap to use ICMP Timestamp to discover live hosts?
Answer: -PP

### What is the option required to tell Nmap to use ICMP Address Mask to discover live hosts?
Answer: -PM

### What is the option required to tell Nmap to use ICMP Echo to discover live hosts?
Answer: -PE

## Task-7: Nmap Host Discovery Using TCP and UDP

### Which TCP ping scan does not require a privileged account?
Answer: TCP SYN Ping

### Which TCP ping scan requires a privileged account?
Answer: TCP ACK Ping

### What option do you need to add to Nmap to run a TCP SYN ping scan on the telnet port?
Answer: -PS23

## Task-8: Using Reverse-DNS Lookup

### We want Nmap to issue a reverse DNS lookup for all the possibles hosts on a subnet, hoping to get some insights from the names. What option should we add?
Answer: -R

## Task-9: Summary -- reading only 

